******************************************
*Cross-Country Evidence on Liquidity Buffers

*******************************************
cd "<place directory here>"
global path "<place directory here>"



clear
import excel "$path\rawdata\Cross-Country Data.xlsx", sheet("Sheet1") firstrow

gen iso=country

merge 1:1 iso year using "$path\rawdata\jorda.dta", nogen keep(match master)


egen id=group(country)

sort year
by year: gen obs_year=_N 
keep if obs_year>20 



tsset id year 

gen diff_liq_dinc= liq_dinc_m/l1.liq_dinc_m-1

gen diff_hprice_income=hprice_income/l1.hprice_income-1

gen diff_dinc= dinc/l1.dinc-1

gen inflation=(cpi/l1.cpi-1)*100 

gen diff_inflation=inflation/l1.inflation-1

gen population_growth=pop/l1.pop-1

gen diff_employment=emp_rate/l1.emp_rate-1 

gen diff_hdebt=hdebt_netdinc/l1.hdebt_netdinc-1

gen diff_dti=dti/l1.dti-1

gen diff_aging=aging/l1.aging-1 

gen diff_ltrate=ltrate/l1.ltrate-1 

gen diff_strate=stir/l1.stir-1

gen diff_gdp=gdp/l1.gdp-1


*real interest rates 
gen rintrate_l = (1+ltrate)/(1+inflation) -1
replace rintrate_l=. if rintrate_l>20 
gen rintrate_s = (1+stir)/(1+inflation) -1
replace rintrate_s = . if rintrate_s >20 


*changes in real rates 
gen diff_rintrate_l=rintrate_l/l1.rintrate_l-1 
gen diff_rintrate_s=rintrate_s/l1.rintrate_s-1 

*Figure 2: Household Liquid Assets, OECD countries 
collapse(median) median=liq_dinc_m (p25) p25=liq_dinc_m (p75) p75=liq_dinc_m, by(year)

*Table B1: Change in Liquidity Buffer
reg diff_liq_dinc diff_hprice_income diff_ltrate population_growth diff_employment diff_aging, cl(id)

reg diff_liq_dinc diff_dti diff_rintrate_l diff_inflation population_growth diff_employment diff_aging, cl(id)





******************
*LOCAL PROJECTIONS
******************

gen b=0
gen u=0
gen d=0

foreach x in liq_dinc_m {
forv h = 0/5 {
gen `x'`h' = f`h'.`x' - l.`x' 			// Use for cumulative IRF

}
}


cap drop b u d Years Zero
gen horizon = _n-1 if _n<=6
gen zero =  0    if _n<=6

forv h = 0/4 {
xtreg liq_dinc_m`h' diff_ltrate l1.liq_dinc_m diff_hprice_income diff_aging diff_inflation diff_gdp, cl(id) fe 
replace b = _b[diff_ltrate]                     if _n == `h'+2
replace u = _b[diff_ltrate] + 1.645* _se[diff_ltrate]  if _n == `h'+2
replace d = _b[diff_ltrate] - 1.645* _se[diff_ltrate]  if _n == `h'+2
*eststo 
}

replace b=-b
replace u=-u
replace d=-d 


*Figure B1: Response of Liquidity Buffer to 1ppt Interest Rate Cut 		
order u d b horizon zero 
outsheet using "oecd_lp.csv", replace comma



























